/*
 * Decompiled with CFR 0.152.
 */
package BryceMath;

import BryceMath.Factories.ExpressionFactory;
import BryceMath.Factories.NumberFactory;
import BryceMath.Numbers.BaseNumber;
import BryceMath.Numbers.Complex;
import BryceMath.Numbers.Equation;
import BryceMath.Numbers.Expression;
import BryceMath.Numbers.IntB;
import BryceMath.Numbers.Multinomial;
import BryceMath.Numbers.Rational;
import util.Print;
import util.testing;

public class test_numbers {
    static final int TEST_SIZE = 10000;

    public test_numbers() {
        this.test_BaseNumber();
        this.test_BigIntegers();
        this.test_Rationals();
        this.test_Complex();
        this.test_Multinomials();
        this.test_Expressions();
        this.test_Equations();
        this.test_conj();
        Print.print("All numeric tests passed!");
    }

    private void test_BaseNumber() {
        BaseNumber result = new BaseNumber(10);
        testing.ASSERT(result.toString().equals("0"));
        result.add(5);
        testing.ASSERT(result.toString().equals("5"));
        result.mult(4);
        testing.ASSERT(result.toString().equals("20"));
        result.mult(20);
        testing.ASSERT(result.toString().equals("400"));
        result.mult(347);
        testing.ASSERT(result.toString().equals("138800"));
        result = new BaseNumber(16);
        result.add(87);
        testing.ASSERT(result.toString().equals("57"));
        result = new BaseNumber(2);
        result.add(6);
        testing.ASSERT(result.toString().equals("110"));
        result.mult(10);
        result.add(1);
        testing.ASSERT(result.toString().equals("111101"));
        result.mult(10);
        result.add(5);
        testing.ASSERT(result.toString().equals("1001100111"));
        result.mult(10);
        testing.ASSERT(result.toString().equals("1100000000110"));
        result.add(2);
        testing.ASSERT(result.toString().equals("1100000001000"));
    }

    private void test_BigIntegers() {
        IntB in2 = NumberFactory.I(-2);
        testing.ASSERT(in2.toString().equals("-2"));
        IntB in1 = NumberFactory.I(-1);
        testing.ASSERT(in1.eq(IntB.ONE.neg()));
        testing.ASSERT(in1.toString().equals("-1"));
        IntB i0 = NumberFactory.I(0);
        testing.ASSERT(i0.eq(IntB.ZERO));
        testing.ASSERT(i0.eq(i0.zero()));
        testing.ASSERT(i0.eq(0));
        testing.ASSERT(i0.toString().equals("0"));
        IntB i1 = NumberFactory.I(1);
        testing.ASSERT(i1.eq(IntB.ONE));
        testing.ASSERT(i1.eq(i1.one()));
        testing.ASSERT(i1.eq(1));
        testing.ASSERT(i1.toString().equals("1"));
        IntB i2 = NumberFactory.I(2);
        testing.ASSERT(i2.toString().equals("2"));
        testing.ASSERT(i2.compareTo(in2) > 0);
        testing.ASSERT(in2.compareTo(i2) < 0);
        testing.ASSERT(i1.compareTo(in2) > 0);
        testing.ASSERT(in1.compareTo(i2) < 0);
        testing.ASSERT(i2.compareTo(i2) == 0);
        testing.ASSERT(in2.compareTo(in2) == 0);
        testing.ASSERT(i0.equals(i0.add(i0)));
        testing.ASSERT(i1.equals(i1.add(i0)));
        testing.ASSERT(i1.equals(i0.add(i1)));
        IntB result = in1.add(in1);
        testing.ASSERT(result.equals(in2));
        testing.ASSERT(result.toString().equals("-2"));
        result = in2.add(i1);
        testing.ASSERT(result.equals(in1));
        testing.ASSERT(result.toString().equals("-1"));
        result = i2.add(in1);
        testing.ASSERT(result.equals(i1));
        testing.ASSERT(result.toString().equals("1"));
        result = i1.add(i1);
        testing.ASSERT(result.equals(i2));
        testing.ASSERT(result.toString().equals("2"));
        result = i0;
        int i = 0;
        while (i <= 10000) {
            result = result.add(NumberFactory.I(i));
            ++i;
        }
        testing.ASSERT(result.toString().equals("50005000"));
        result = i0;
        i = 0;
        while (i <= 10000) {
            result = result.add(NumberFactory.I(-i));
            ++i;
        }
        testing.ASSERT(result.toString().equals("-50005000"));
        result = i0;
        i = 0;
        while (i <= 10000) {
            result = result.add(NumberFactory.I((int)(Math.pow(-1.0, i) * (double)i)));
            ++i;
        }
        testing.ASSERT(result.toString().equals("5000"));
        result = i2.sub(i1);
        testing.ASSERT(result.eq(i1));
        result = i1.sub(i2);
        testing.ASSERT(result.eq(in1));
        result = i1.sub(in1);
        testing.ASSERT(result.eq(i2));
        result = in1.sub(i1);
        testing.ASSERT(result.eq(in2));
        result = in1.sub(in2);
        testing.ASSERT(result.eq(i1));
        result = in2.sub(in1);
        testing.ASSERT(result.eq(in1));
        result = i2.sub(i2);
        testing.ASSERT(result.eq(i0));
        result = in2.sub(in2);
        testing.ASSERT(result.eq(i0));
        result = in1;
        i = 0;
        while (i < 100) {
            result = result.sub(result.neg());
            ++i;
        }
        testing.ASSERT(result.toString().equals("-1267650600228229401496703205376"));
        result = i0.sub(i1);
        testing.ASSERT(result.toString().equals("-1"));
        result = i0.sub(in1);
        testing.ASSERT(result.toString().equals("1"));
        result = i1.sub(i0);
        testing.ASSERT(result.toString().equals("1"));
        result = in1.sub(i0);
        testing.ASSERT(result.toString().equals("-1"));
        result = (IntB)NumberFactory.I(172).sub(252);
        testing.ASSERT(result.eq(-80));
        testing.ASSERT(in2.mult(i1).eq(in2));
        testing.ASSERT(in1.mult(i1).eq(in1));
        testing.ASSERT(i0.mult(i1).eq(i0));
        testing.ASSERT(i1.mult(i1).eq(i1));
        testing.ASSERT(i2.mult(i1).eq(i2));
        testing.ASSERT(i1.mult(in2).eq(in2));
        testing.ASSERT(i1.mult(in1).eq(in1));
        testing.ASSERT(i1.mult(i0).eq(i0));
        testing.ASSERT(i1.mult(i1).eq(i1));
        testing.ASSERT(i1.mult(i2).eq(i2));
        testing.ASSERT(in2.eq(i2.mult(in1)));
        testing.ASSERT(in1.eq(i1.mult(in1)));
        testing.ASSERT(i2.eq(in2.mult(in1)));
        testing.ASSERT(in2.eq(in1.mult(i2)));
        testing.ASSERT(in1.eq(in1.mult(i1)));
        testing.ASSERT(i2.eq(in1.mult(in2)));
        result = i2.mult(i2);
        testing.ASSERT(result.toString().equals("4"));
        testing.ASSERT(result.eq(4));
        result = i1;
        i = 0;
        while (i < 100) {
            result = result.mult(i2);
            ++i;
        }
        testing.ASSERT(result.toString().equals("1267650600228229401496703205376"));
        result = i1;
        i = 1;
        while (i <= 50) {
            result = result.mult(NumberFactory.I(i));
            ++i;
        }
        testing.ASSERT(result.toString().equals("30414093201713378043612608166064768844377641568960512000000000000"));
        result = (IntB)NumberFactory.I(-56786).mult(23798798);
        testing.ASSERT(result.toString().equals("-1351438543228"));
        result = (IntB)NumberFactory.I(23798798).mult(-56786);
        testing.ASSERT(result.toString().equals("-1351438543228"));
        result = NumberFactory.I(-43278).mult(NumberFactory.I(-9876543));
        testing.ASSERT(result.toString().equals("427437027954"));
        boolean success = true;
        try {
            i0.div(i0);
            success = false;
        }
        catch (Error error) {
            // empty catch block
        }
        try {
            NumberFactory.I(59437).div(i0);
            success = false;
        }
        catch (Error error) {
            // empty catch block
        }
        testing.ASSERT(success);
        testing.ASSERT(NumberFactory.I(89898989).div(i1).eq(NumberFactory.I(89898989)));
        testing.ASSERT(NumberFactory.I(4327983).div(NumberFactory.I(4327983)).eq(i1));
        result = (IntB)NumberFactory.I(432349873).div(98732);
        testing.ASSERT(result.toString().equals("4379"));
        result = (IntB)NumberFactory.I(81).div(9);
        testing.ASSERT(result.toString().equals("9"));
        result = (IntB)NumberFactory.I(81).div(9);
        testing.ASSERT(result.toString().equals("9"));
        result = (IntB)NumberFactory.I(373030).div(23780);
        testing.ASSERT(result.toString().equals("15"));
        result = (IntB)NumberFactory.I(2468).div(2);
        testing.ASSERT(result.eq(1234));
        result = (IntB)NumberFactory.I(144).div(-12);
        testing.ASSERT(result.eq(-12));
        result = (IntB)NumberFactory.I(-347).div(10);
        testing.ASSERT(result.eq(-34));
        result = (IntB)NumberFactory.I(123456789).div(123456790);
        testing.ASSERT(result.toString().equals("0"));
        result = (IntB)NumberFactory.I(123456789).mod(123456790);
        testing.ASSERT(result.toString().equals("123456789"));
        result = (IntB)NumberFactory.I(56).mod(17);
        testing.ASSERT(result.toString().equals("5"));
        result = (IntB)NumberFactory.I(78).mod(67);
        testing.ASSERT(result.eq(11));
        result = (IntB)NumberFactory.I(-78).mod(67);
        testing.ASSERT(result.eq(56));
        result = (IntB)NumberFactory.I(78).mod(-67);
        testing.ASSERT(result.eq(-56));
        result = (IntB)NumberFactory.I(-78).mod(-67);
        testing.ASSERT(result.eq(-11));
        success = true;
        try {
            i0.mod(i0);
            success = false;
        }
        catch (Error error) {
            // empty catch block
        }
        try {
            NumberFactory.I(59437).mod(i0);
            success = false;
        }
        catch (Error error) {
            // empty catch block
        }
        testing.ASSERT(success);
        result = (IntB)NumberFactory.I(345).mod(252);
        testing.ASSERT(result.eq(93));
        int max = Integer.MAX_VALUE;
        int min = Integer.MIN_VALUE;
        IntB MAX = NumberFactory.I(max);
        IntB MIN = NumberFactory.I(min);
        testing.ASSERT(MAX.toInt() == max);
        testing.ASSERT(MIN.toInt() == -min);
        testing.ASSERT(in2.toInt() == -2);
        testing.ASSERT(in1.toInt() == -1);
        testing.ASSERT(i0.toInt() == 0);
        testing.ASSERT(i1.toInt() == 1);
        testing.ASSERT(i2.toInt() == 2);
        testing.ASSERT(NumberFactory.I(324798).toInt() == 324798);
        testing.ASSERT(NumberFactory.I(-324798).toInt() == -324798);
        long maxL = Long.MAX_VALUE;
        long minL = Long.MIN_VALUE;
        IntB MAXL = NumberFactory.I(maxL);
        IntB MINL = NumberFactory.I(minL);
        testing.ASSERT(MAXL.toLong() == maxL);
        testing.ASSERT(MINL.toLong() == -minL);
        testing.ASSERT(in2.toLong() == -2L);
        testing.ASSERT(in1.toLong() == -1L);
        testing.ASSERT(i0.toLong() == 0L);
        testing.ASSERT(i1.toLong() == 1L);
        testing.ASSERT(i2.toLong() == 2L);
        testing.ASSERT(NumberFactory.I(324798005600L).toLong() == 324798005600L);
        testing.ASSERT(NumberFactory.I(-324798005600L).toLong() == -324798005600L);
        result = (IntB)NumberFactory.I(2).pow(100);
        testing.ASSERT(result.toString().equals("1267650600228229401496703205376"));
        result = (IntB)NumberFactory.I(67).pow(87);
        testing.ASSERT(result.toString().equals("738767590750132809484087434974544164876448944195922356184303556933534287692449121264386896790090535068380171690486648774057318149756968018646121051563466528523"));
        result = NumberFactory.I(4).AND(3);
        testing.ASSERT(result.eq(0));
        result = NumberFactory.I(24390).AND(34827);
        testing.ASSERT(result.eq(2050));
        testing.ASSERT(NumberFactory.I(99999999).AND(0).eq(0));
        testing.ASSERT(NumberFactory.I(678).AND(45).eq(36));
        testing.ASSERT(NumberFactory.I(-678).AND(45).eq(-36));
        testing.ASSERT(NumberFactory.I(678).AND(-45).eq(-36));
        testing.ASSERT(NumberFactory.I(-678).AND(-45).eq(-36));
        result = NumberFactory.I(63).OR(0);
        testing.ASSERT(result.eq(63));
        result = NumberFactory.I(2523).OR(388837);
        testing.ASSERT(result.eq(389119));
        testing.ASSERT(NumberFactory.I(678).OR(45).eq(687));
        testing.ASSERT(NumberFactory.I(-678).OR(45).eq(687));
        testing.ASSERT(NumberFactory.I(678).OR(-45).eq(687));
        testing.ASSERT(NumberFactory.I(-678).OR(-45).eq(-687));
        testing.ASSERT(NumberFactory.I(567).XOR(79).eq(-632));
        testing.ASSERT(NumberFactory.I(-567).XOR(79).eq(632));
        testing.ASSERT(NumberFactory.I(-567).XOR(-79).eq(-632));
        testing.ASSERT(NumberFactory.I(567).XOR(-79).eq(632));
        String input = "6152348723894723984729834723852375902843509238";
        result = new IntB(input);
        testing.ASSERT(result.toString().equals(input));
        input = "0";
        result = new IntB(input);
        testing.ASSERT(result.toString().equals(input));
        input = "-34082740";
        result = new IntB(input);
        testing.ASSERT(result.toString().equals(input));
    }

    private void test_Rationals() {
        Rational result = Rational.ZERO;
        testing.ASSERT(result.toString().equals("0"));
        testing.ASSERT(result.eq(0));
        testing.ASSERT(result.equals(result));
        testing.ASSERT(result.eq(Rational.ZERO));
        testing.ASSERT(result.eq(NumberFactory.R(0)));
        result = NumberFactory.R(9834496, 3136);
        testing.ASSERT(result.eq(NumberFactory.R(3136)));
        result = NumberFactory.R(3, -4);
        testing.ASSERT(result.eq(NumberFactory.R(-3, 4)));
        result = NumberFactory.R(-3, -4);
        testing.ASSERT(result.eq(NumberFactory.R(3, 4)));
        result = NumberFactory.R(345, 597).add(NumberFactory.R(43788, 23));
        testing.ASSERT(result.eq(NumberFactory.R(8716457, 4577)));
        result = NumberFactory.R(NumberFactory.I(27598237), NumberFactory.I(1238762178)).add(NumberFactory.R(NumberFactory.I("1793264197326"), NumberFactory.I("4327462378")));
        testing.ASSERT(result.equals(NumberFactory.R(NumberFactory.I("1110773646570647081807"), NumberFactory.I("2680348360292169642"))));
        result = NumberFactory.R("27598237/1238762178").sub(NumberFactory.R("1793264197326/4327462378"));
        testing.ASSERT(result.equals(NumberFactory.R("-1110654216238330454221/2680348360292169642")));
        result = NumberFactory.R(1, 4).sub(NumberFactory.R(-3, 4));
        testing.ASSERT(result.eq(Rational.ONE));
        result = NumberFactory.R("46328794/48793210941379").mult(NumberFactory.R("347623784687321648/83741984798"));
        testing.ASSERT(result.eq(NumberFactory.R("8052495355139639520966256/2043020164449283743578221")));
        result = NumberFactory.R(3, -4).mult(NumberFactory.R(-1, -2));
        testing.ASSERT(result.eq(NumberFactory.R(-3, 8)));
        result = NumberFactory.R("349824792/47239429849832").div(NumberFactory.R("213678213612876/90909090909090"));
        testing.ASSERT(result.eq(NumberFactory.R("73616328282827546665/23365826348154798423290826")));
        Rational r0 = Rational.ZERO;
        boolean success = true;
        try {
            r0.mod(r0);
            success = false;
        }
        catch (Error error) {
            // empty catch block
        }
        try {
            NumberFactory.R(59437).mod(r0);
            success = false;
        }
        catch (Error error) {
            // empty catch block
        }
        try {
            NumberFactory.R(59467).div(r0);
            success = false;
        }
        catch (Error error) {
            // empty catch block
        }
        try {
            r0.div(r0);
            success = false;
        }
        catch (Error error) {
            // empty catch block
        }
        try {
            result = NumberFactory.R("14524176867349327498/0");
            success = false;
        }
        catch (Error error) {
            // empty catch block
        }
        testing.ASSERT(success);
        result = NumberFactory.R(45, 4);
        testing.ASSERT(result.part_int().eq(11));
        testing.ASSERT(result.part_frac().eq(NumberFactory.R(1, 4)));
        result = NumberFactory.R(-389, 23);
        testing.ASSERT(result.part_int().eq(-16));
        testing.ASSERT(result.part_frac().eq(NumberFactory.R(-21, 23)));
        result = NumberFactory.R(".45");
        testing.ASSERT(result.eq(NumberFactory.R(45, 100)));
        result = NumberFactory.R("45525");
        testing.ASSERT(result.eq(NumberFactory.R(45525)));
        result = NumberFactory.R("143.234");
        testing.ASSERT(result.eq(NumberFactory.R(143234, 1000)));
        result = NumberFactory.R("1.56/23.56");
        testing.ASSERT(result.eq(NumberFactory.R(39, 589)));
    }

    private void test_Complex() {
        Complex c1 = NumberFactory.C(0, 0);
        testing.ASSERT(c1.toString().equals("0"));
        testing.ASSERT(c1.eq(Complex.ZERO));
        testing.ASSERT(c1.equals(Complex.ZERO));
        testing.ASSERT(c1.eq(0));
        c1 = NumberFactory.C(1, 0);
        testing.ASSERT(c1.toString().equals("1"));
        testing.ASSERT(c1.eq(Complex.ONE));
        testing.ASSERT(c1.equals(Complex.ONE));
        testing.ASSERT(c1.eq(1));
        c1 = NumberFactory.C(NumberFactory.R(5, 6), NumberFactory.R(-7, 8));
        testing.ASSERT(c1.part_real().toString().equals("\\frac{5}{6}"));
        testing.ASSERT(c1.part_imaginary().toString().equals("\\frac{-7}{8}"));
        c1 = NumberFactory.C(NumberFactory.R(5, 6), NumberFactory.R(8));
        Complex c2 = NumberFactory.C(NumberFactory.R(-74, 893), NumberFactory.R(1, -2));
        Complex c3 = c1.add(c2);
        testing.ASSERT(c3.eq(NumberFactory.C(NumberFactory.R(4021, 5358), NumberFactory.R(15, 2))));
        c3 = c1.sub(c2);
        testing.ASSERT(c3.eq(NumberFactory.C(NumberFactory.R(4909, 5358), NumberFactory.R(17, 2))));
        c3 = c1.mult(c2);
        testing.ASSERT(c3.eq(NumberFactory.C(NumberFactory.R(10531, 2679), NumberFactory.R(-11569, 10716))));
        c3 = (Complex)NumberFactory.C(1, 5).mult(-1);
        testing.ASSERT(c3.eq(NumberFactory.C(-1, -5)));
        c3 = c3.neg();
        testing.ASSERT(c3.eq(NumberFactory.C(1, 5)));
        c3 = c1.div(c2);
        testing.ASSERT(c3.eq(NumberFactory.C(NumberFactory.R(-38938372, 2458059), NumberFactory.R(-2356627, 2458059))));
        c1 = NumberFactory.C(NumberFactory.R(56, 1), NumberFactory.R(5, 3));
        c2 = c1.conj();
        testing.ASSERT(c2.eq(NumberFactory.C(NumberFactory.R(56, 1), NumberFactory.R(-5, 3))));
        testing.ASSERT(c1.part_real().eq(NumberFactory.R(56, 1)));
        testing.ASSERT(c1.part_imaginary().eq(NumberFactory.R(5, 3)));
        c1 = NumberFactory.C(5, 5);
        c2 = Complex.I;
        c3 = c1.mult(c2);
        testing.ASSERT(c3.eq(NumberFactory.C(-5, 5)));
    }

    private void test_Multinomials() {
        Multinomial m1 = new Multinomial(0L);
        testing.ASSERT(m1.toString().equals("0"));
        m1 = new Multinomial(1L);
        testing.ASSERT(m1.toString().equals("1"));
        testing.ASSERT(Multinomial.ONE.toString().equals("1"));
        testing.ASSERT(Multinomial.ZERO.toString().equals("0"));
        m1 = new Multinomial(385729L);
        testing.ASSERT(m1.toString().equals("385729"));
        m1 = new Multinomial(5L, "X");
        testing.ASSERT(m1.toString().equals("5X"));
        Multinomial m2 = new Multinomial(-6L, "Y");
        testing.ASSERT(m2.toString().equals("-6Y"));
        Multinomial m3 = m1.add(m2);
        testing.ASSERT(m3.toString().equals("5X - 6Y"));
        m3 = m3.add(m3);
        testing.ASSERT(m3.toString().equals("10X - 12Y"));
        m1 = new Multinomial(-10L, "X");
        m3 = m3.add(m1);
        testing.ASSERT(m3.toString().equals("-12Y"));
        m2 = new Multinomial(12L, "Y");
        m3 = m3.add(m2);
        testing.ASSERT(m3.toString().equals("0"));
        m3 = m1.sub(m2);
        testing.ASSERT(m3.toString().equals("-10X - 12Y"));
        m3 = (Multinomial)m3.mult(2);
        testing.ASSERT(m3.toString().equals("-20X - 24Y"));
        m3 = (Multinomial)m3.div(4);
        testing.ASSERT(m3.toString().equals("-5X - 6Y"));
        m1 = NumberFactory.M(0L);
        m1 = (Multinomial)m1.mult(1);
        testing.ASSERT(m1.toString().equals("0"));
        m1 = NumberFactory.M(5L).add(NumberFactory.M("X"));
        m1 = (Multinomial)m1.mult(56);
        testing.ASSERT(m1.eq(NumberFactory.M(280L).add(NumberFactory.M(56L, "X"))));
        m2 = NumberFactory.M(67L, "Y").add(NumberFactory.M(34L));
        String s1 = m1.mult(m2).mult(NumberFactory.M("X")).add(NumberFactory.M(5L)).toString();
        String s2 = "3752X^{2}Y + 1904X^{2} + 18760XY + 9520X + 5";
        testing.ASSERT(s1.equals(s2));
        boolean success = true;
        try {
            m1.div(false);
            success = false;
        }
        catch (Error error) {
            // empty catch block
        }
        try {
            m1.div(NumberFactory.M(0L, "E"));
            success = false;
        }
        catch (Error error) {
            // empty catch block
        }
        try {
            m1.div(NumberFactory.M(1L).sub(NumberFactory.M(1L)));
            success = false;
        }
        catch (Error error) {
            // empty catch block
        }
        try {
            m1.div(false);
            success = false;
        }
        catch (Error error) {
            // empty catch block
        }
        testing.ASSERT(success);
        m1 = NumberFactory.M(5L, "X").add(NumberFactory.M(10L));
        m1 = (Multinomial)m1.div(2);
        testing.ASSERT(m1.equals(NumberFactory.M(NumberFactory.R(5, 2), "X").add(NumberFactory.M(5L))));
        m2 = m1.div(NumberFactory.M("X"));
        testing.ASSERT(m2.eq(NumberFactory.M(NumberFactory.R(5, 2))));
        m1 = NumberFactory.M("Y").mult(NumberFactory.M("X").add(NumberFactory.M(1L)));
        m2 = NumberFactory.M("X").add(NumberFactory.M(4L));
        m1 = m1.mult(m2);
        testing.ASSERT(m1.toString().equals("X^{2}Y + 5XY + 4Y"));
        m1 = m1.div(m2);
        testing.ASSERT(m1.toString().equals("XY + Y"));
        Complex c1 = NumberFactory.C(5, 5).mult(Complex.I);
        m1 = NumberFactory.M(c1);
        testing.ASSERT(m1.toString().equals("-5 + 5i"));
        throw new Error("You should test Multinomials more!");
    }

    private void test_Expressions() {
        Expression e1 = new Expression(0L);
        testing.ASSERT(e1.toString().equals("0"));
        testing.ASSERT(e1.eq(0));
        testing.ASSERT(e1.eq(Expression.ZERO));
        e1 = new Expression(1L);
        testing.ASSERT(e1.toString().equals("1"));
        testing.ASSERT(e1.eq(1));
        testing.ASSERT(e1.eq(Expression.ONE));
        e1 = NumberFactory.E(56);
        testing.ASSERT(e1.toString().equals("56"));
        testing.ASSERT(e1.eq(56));
        Expression e3 = ExpressionFactory.createExpression("56");
        testing.ASSERT(e3.toString().equals("56"));
        testing.ASSERT(e1.toString().equals("56"));
        testing.ASSERT(e1.eq(56));
        e1 = ExpressionFactory.createExpression("-100000000000000000");
        testing.ASSERT(e1.toString().equals("-100000000000000000"));
        e1 = NumberFactory.E(1);
        Expression e2 = NumberFactory.E(1);
        e3 = e1.add(e2);
        testing.ASSERT(e3.eq(2));
        e1 = ExpressionFactory.createExpression("x^{3} + yhj + 89");
        e2 = ExpressionFactory.createExpression("x+6");
        testing.ASSERT(e1.toString().equals("hjy + x^{3} + 89"));
        testing.ASSERT(e2.toString().equals("x + 6"));
        e1 = e1.mult(e2);
        testing.ASSERT(e1.toString().equals("hjxy + x^{4} + 6hjy + 6x^{3} + 89x + 534"));
        e1 = ExpressionFactory.createExpression("6i + 9");
        e2 = ExpressionFactory.createExpression("-9i + 5");
        e3 = e1.mult(e2);
        testing.ASSERT(e3.toString().equals("99 - 51i"));
        e3 = e1.div(e2);
        testing.ASSERT(e3.toSerialString().equals("(-9 + 111i)/(106)"));
        e1 = ExpressionFactory.createExpression("(-40h + 100x - 250)/(35x + 300y - 100)");
        testing.ASSERT(e1.toSerialString().equals("(-8h + 20x - 50)/(7x + 60y - 20)"));
        e1 = ExpressionFactory.createExpression("256x/(256y)");
        testing.ASSERT(e1.toSerialString().equals("(x)/(y)"));
    }

    private void test_Equations() {
        Expression exp1 = ExpressionFactory.createExpression("x^2 + 2x + 4");
        Expression exp2 = ExpressionFactory.createExpression("0");
        Equation e1 = Equation.ONE;
        testing.ASSERT(e1.toString().equals("1"));
        e1 = Equation.ZERO;
        testing.ASSERT(e1.toString().equals("0"));
        e1 = new Equation(exp1);
        testing.ASSERT(e1.toString().equals("x^{2} + 2x + 4"));
        e1 = new Equation(exp1, exp2);
        testing.ASSERT(e1.toString().equals("x^{2} + 2x + 4 = 0"));
        e1 = ExpressionFactory.createEquation("x^2 + xy + y^2 = 89i + 78");
        testing.ASSERT(e1.toString().equals("x^{2} + xy + y^{2} = 78 + 89i"));
        e1 = ExpressionFactory.createEquation("");
        testing.ASSERT(e1.eq(0));
        e1 = ExpressionFactory.createEquation("2x - 5 -.8h");
        testing.ASSERT(e1.toSerialString().equals("(-4h + 10x - 25)/(5)"));
        Equation e2 = ExpressionFactory.createEquation(".7x + 6y - 2");
        Equation e3 = e1.add(e2);
        testing.ASSERT(e3.toSerialString().equals("(-8h + 27x + 60y - 70)/(10)"));
        e1 = ExpressionFactory.createEquation("x");
        e2 = ExpressionFactory.createEquation("y = x");
        e3 = e1.add(e2);
        testing.ASSERT(e3.toSerialString().equals("x + y = 2x"));
        e3 = e2.add(e1);
        testing.ASSERT(e3.toSerialString().equals("x + y = 2x"));
        testing.ASSERT(e3.equals(e3.add(Equation.ZERO)));
        testing.ASSERT(e3.equals(e3.add(Equation.ZERO_ZERO)));
        e3 = e3.sub(e3);
        testing.ASSERT(e3.equals(Equation.ZERO_ZERO));
        e1 = ExpressionFactory.createEquation("2x - 5 -.8h");
        e2 = ExpressionFactory.createEquation(".7x + 6y - 2");
        e3 = e1.sub(e2);
        testing.ASSERT(e3.toSerialString().equals("(-8h + 13x - 60y - 30)/(10)"));
        e3 = e2.sub(e1);
        testing.ASSERT(e3.toSerialString().equals("(8h - 13x + 60y + 30)/(10)"));
        e1 = ExpressionFactory.createEquation("x + 1");
        e2 = ExpressionFactory.createEquation("y = x");
        e3 = e1.sub(e2);
        testing.ASSERT(e3.toSerialString().equals("x - y + 1 = 1"));
        e3 = e2.sub(e1);
        testing.ASSERT(e3.toSerialString().equals("-x + y - 1 = -1"));
        testing.ASSERT(e3.equals(e3.sub(Equation.ZERO)));
        e1 = ExpressionFactory.createEquation("2x - 5 -.8h");
        e2 = ExpressionFactory.createEquation(".7x + 6y - 2");
        e3 = e1.mult(e2);
        testing.ASSERT(e3.toSerialString().equals("(-28hx - 240hy + 70x^{2} + 600xy + 80h - 375x - 1500y + 500)/(50)"));
        e3 = e2.mult(e1);
        testing.ASSERT(e3.toSerialString().equals("(-28hx - 240hy + 70x^{2} + 600xy + 80h - 375x - 1500y + 500)/(50)"));
        e1 = ExpressionFactory.createEquation("x + 1");
        e2 = ExpressionFactory.createEquation("y = x");
        e3 = e1.mult(e2);
        testing.ASSERT(e3.toSerialString().equals("xy + y = x^{2} + x"));
        e3 = e2.mult(e1);
        testing.ASSERT(e3.toSerialString().equals("xy + y = x^{2} + x"));
        testing.ASSERT(e3.eq(e3.mult(Equation.ONE)));
        e1 = ExpressionFactory.createEquation("2x - 5 -.8h");
        e2 = ExpressionFactory.createEquation(".7x + 6y - 2");
        e3 = e2.div(e1);
        testing.ASSERT(e3.toSerialString().equals("(-7x - 60y + 20)/(8h - 20x + 50)"));
        e3 = e1.div(e2);
        testing.ASSERT(e3.toSerialString().equals("(-8h + 20x - 50)/(7x + 60y - 20)"));
        e1 = ExpressionFactory.createEquation("x + 1");
        e2 = ExpressionFactory.createEquation("y = x");
        throw new Error("You should find some more things to test regarding equations...");
    }

    private void test_conj() {
        IntB n1 = new IntB(78);
        testing.ASSERT(((IntB)n1.conj()).eq(78));
        Rational n2 = new Rational(78L, 24L);
        testing.ASSERT(((Rational)n2.conj()).eq(n2));
        Complex n3 = new Complex(n2, n2);
        testing.ASSERT(n3.conj().eq(new Complex(n2, n2.neg())));
    }
}

